﻿var choiceListTableEditor = {
    choices: {},
    currentData: null,
    currentIndex: 1,
    datatable: null,
    choiceListId: 0,
    showDefault: true,
    showFixed: true,
    showExclusive: false,
    showHeader: false,
    isDrillDownList: false,
    isFirstDropdown: false,
    drilldownParentOptions: null,
    lastId: 0,
    nextId: 1,
    lastCode: 0,
    lastPosition: 1,
    refreshDataTable: function () {
        var currentPage = choiceListTableEditor.datatable.a4datatable("getCurrentPage");
        choiceListTableEditor.datatable.a4datatable("option", "data", _.filter(choiceListTableEditor.choices, function (c) { return !c.Deleted; }));
        choiceListTableEditor.datatable.a4datatable("setCurrentPage", currentPage);
    },
    initializeDataTable: function () {
        var parentOptions;

        if (choiceListTableEditor.isDrillDownList) {
            parentOptions = _.map(choiceListTableEditor.drilldownParentOptions, function (o) {
                return { Label: o.Text, Value: o.Code };
            });
        }

        this.datatable = $(".v-choicesTable").a4datatable({
            serverSide: false,
            displayColumnSelector: false,
            data: _.filter(choiceListTableEditor.choices, function (c) { return !c.Deleted; }),
            columns: [
                { "Name": "Id", "Data": "Id", "Visible": false, "Key": true },
                { "Name": "ChoiceListId", "Data": "ChoiceListId", "Visible": false },
                { "Name": "Code", "Title": resources.Code, "Data": "Code", "Editable": true },
                { "Name": "Text", "Title": resources.Text, "Data": "Text", "Type": "richtext", "Sortable": false, "Editable": true, "Width": (choiceListTableEditor.isDrillDownList ? "40%" : "55%") },
                { "Name": "ParentValue", "Title": resources.Parent, "Data": "ParentValue", "Type": "enum", "EnumType": parentOptions, "Sortable": false, "Searchable": false, "Editable": !choiceListTableEditor.isFirstDropdown, "Visible": choiceListTableEditor.isDrillDownList },
                { "Name": "Default", "Title": resources.Default, "Data": "Default", "Type": "boolean", "Sortable": false, "Searchable": false, "Editable": true, "ShowIcon": true, "Visible": choiceListTableEditor.showDefault },
                { "Name": "Visible", "Title": resources.Visible, "Data": "Visible", "Type": "boolean", "Sortable": false, "Searchable": false, "Editable": true, "ShowIcon": true },
                { "Name": "Exclusive", "Title": resources.Exclusive, "Data": "Exclusive", "Type": "boolean", "Sortable": false, "Searchable": false, "Editable": true, "ShowIcon": true, "Visible": choiceListTableEditor.showExclusive },
                { "Name": "Fixed", "Title": resources.Fixed, "Data": "Fixed", "Type": "boolean", "Sortable": false, "Searchable": false, "Editable": true, "ShowIcon": true, "Visible": choiceListTableEditor.showFixed },
                { "Name": "Header", "Title": resources.Header, "Data": "Header", "Type": "boolean", "Sortable": false, "Searchable": false, "Editable": true, "ShowIcon": true, "Visible": choiceListTableEditor.showHeader },
                { "Name": "Position", "Data": "Position", "Visible": false }
            ],
            toolBarItems: choiceListTableEditor.getToolBarItems(),
            contextMenuItems: choiceListTableEditor.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "deleteAll":
                        _.each(choiceListTableEditor.choices, function (c) { c.Deleted = true; });
                        choiceListTableEditor.refreshDataTable();
                        break;
                    case "addChoice":
                        var choices = _.filter(choiceListTableEditor.choices, function (c) { return !c.Deleted; })
                        var maxChoice = (_.size(choices) == 0) ? 0 : _.max(choices, function (c) { return isNaN(c.Code) ? 0 : parseInt(c.Code); });
                        var code = (maxChoice) ? parseInt(maxChoice.Code) + 1 : 1;
                        choiceListTableEditor.addChoice(code, "");
                        choiceListTableEditor.refreshDataTable();
                        choiceListTableEditor.datatable.a4datatable("setCurrentPage", "last");
                        break;
                    case "moveUp":
                        choiceListTableEditor.moveItems(ids, false);
                        break;
                    case "moveDown":
                        choiceListTableEditor.moveItems(ids, true);
                        break;
                    case "moveTo":
                        choiceListTableEditor.showMoveToDialog(function (moveDown, moveToVariable) {
                            choiceListTableEditor.moveToItems(ids, moveToVariable, moveDown);
                        });
                        break;
                    case "delete":
                        choiceListTableEditor.deleteItems(ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        choiceListTableEditor.editChoice(row.Id);
                        break;
                    case "editLogic":
                        var choice = _.find(choiceListTableEditor.choices, function (c) { return c.Id == row.Id; });
                        var skipLogic = (choice && choice.SkipLogic) ? choice.SkipLogic : null;
                        var skipData = (skipLogic && skipLogic !== undefined) ? skipLogic : "";
                        var displayLogic = (choice && choice.DisplayLogic) ? choice.DisplayLogic : null;
                        var dataDisplay = (displayLogic && displayLogic !== undefined) ? displayLogic : "";
                        modalDialog.showWindow(a4.top().questionnaireEditor.getUrl("ChoiceSkipLogic", { choiceListId: row.ChoiceListId, choiceId: row.Id, skipLogic: skipData, displayLogic: dataDisplay }), 500, 850);
                        break;
                    case "moveUp":
                        choiceListTableEditor.moveItems([row.Id], false);
                        break;
                    case "moveDown":
                        choiceListTableEditor.moveItems([row.Id], true);
                        break;
                    case "moveTo":
                        choiceListTableEditor.showMoveToDialog(function (moveDown, moveToVariable) {
                            choiceListTableEditor.moveToItems([row.Id], moveToVariable, moveDown);
                        });
                        break;
                    case "delete":
                        choiceListTableEditor.deleteItems([row.Id]);
                        break;
                }
            },
            rowUpdated: function (row, data) {
                var rowData = data.data;
                var choice = _.find(choiceListTableEditor.choices, function (c) { return c.Id == rowData.Id; });

                if (choice) {
                    if (choiceListTableEditor.isDrillDownList && choice.Code != rowData.Code) {
                        choiceListTableEditor.propagateCodeChange(choice.Code, rowData.Code);
                    }

                    choice.Code = (rowData.Code && !rowData.Header) ? rowData.Code : "";
                    choice.Text = rowData.Text;
                    choice.Default = rowData.Default;
                    choice.Visible = rowData.Visible;
                    choice.Exclusive = rowData.Exclusive;
                    choice.Fixed = rowData.Fixed;
                    choice.ParentValue = rowData.ParentValue;
                    choice.Edited = true;
                    choice.Header = rowData.Header;
                }
            },
            multiEdit: true,
            height: "full"
        });
    },
    propagateCodeChange: function (oldCode, newCode) {
        var editQuestion = a4.top().questionnaireEditor.getInEditQuestion();
        var descendant = $(".v-drilldownEditorContainer .v-questionEditableItem[data-listId='" + choiceListTableEditor.choiceListId + "']", editQuestion).next();

        if (descendant.length > 0) {
            var applyCodeChange = function (data) {
                _.each(_.filter(data, function (c) { return c.ParentValue == oldCode; }), function (item) {
                    item.ParentValue = newCode;
                });

                a4.top().questionnaireEditor.setChoiceListChoices(descendant.attr("data-listId"), data);
            }

            if (descendant.data("choices")) {
                applyCodeChange(descendant.data("choices"));
            }
            else {
                var listId = descendant.attr("data-listId");
                return a4.top().questionnaireEditor.loadLargeListChoices(listId, listId, false, applyCodeChange);
            }
        }

    },
    moveItems: function (items, moveDown) {
        if (moveDown)
            choiceListTableEditor.choices = choiceListTableEditor.choices.reverse();

        var index = 0;
        var foundIndex = 0;
        var tmp = null;
        var tmpPosition = null;

        _.each(choiceListTableEditor.choices, function (v) {
            if (index != 0 && (foundIndex = _.indexOf(items, v.Id)) != -1) {
                tmp = choiceListTableEditor.choices[index];
                tmpPosition = tmp.Position;
                choiceListTableEditor.choices[index].Position = choiceListTableEditor.choices[index - 1].Position;
                choiceListTableEditor.choices[index] = choiceListTableEditor.choices[index - 1];
                choiceListTableEditor.choices[index - 1].Position = tmpPosition;
                choiceListTableEditor.choices[index - 1] = tmp;
            }

            index++;
        });

        if (moveDown)
            choiceListTableEditor.choices = choiceListTableEditor.choices.reverse();

        choiceListTableEditor.refreshDataTable();
    },
    moveToItems: function (items, source, moveAfter) {
        var foundIndex = null;
        var tmp = null;
        var foundPosition = null;

        _.each(items, function (id) {
            var choiceIds = _.pluck(choiceListTableEditor.choices, "Id");
            var sourceIndex = _.indexOf(choiceIds, source);

            if (sourceIndex > -1 && (foundIndex = _.indexOf(choiceIds, id)) != -1 && foundIndex != sourceIndex) {

                // If moving item closer to start in list
                var moveAbove = (sourceIndex < foundIndex);

                // Insert
                tmp = choiceListTableEditor.choices[sourceIndex];
                var insertIndex = (moveAfter) ? (sourceIndex + 1) : sourceIndex;
                choiceListTableEditor.choices.splice(insertIndex, 0, choiceListTableEditor.choices[foundIndex]);
                var removeIndex = moveAbove ? foundIndex + 1 : foundIndex;
                choiceListTableEditor.choices.splice(removeIndex, 1);

                if (moveAfter) {
                    source = id;
                }
            }
        });

        // Replace positions  
        var position = 1;
        var size = _.size(choiceListTableEditor.choices);

        for (var i = 0 ; i != size; i++) {
            choiceListTableEditor.choices[i].Position = position++;
        }

        choiceListTableEditor.refreshDataTable();
    },
    showMoveToDialog: function (callback) {
        var moveContainer = $("#moveToPanel").clone();
        var container = $('<div id="MoveChoiceToPanel">').append(moveContainer.html().replace(/moveBeforeLocation/g, "moveBeforeLocationEdit").replace(/moveAfterLocation/g, "moveAfterLocationEdit"));

        var initContentFunction = function () {
            var editor = $("#MoveChoiceToPanel");

            $(".v-moveToChoice", editor).a4autocomplete({
                data: choiceListTableEditor.choices,
                valueProperty: "Id",
                labelProperty: "Text"
            });
        }

        var validateContentFunction = function () {
            var editor = $("#MoveChoiceToPanel");
            var valid = ($(".v-moveToChoice", editor).val() != "");

            if (!valid) {
                a4.showErrorMessage(resources.SelectVariable);
            }

            return valid;
        }

        var moveResources = {
            "Title": resources.MoveTo,
            "Message": container
        };

        modalDialog.showConfirmDialog(moveResources,
            function () {
                var editor = $("#MoveChoiceToPanel");
                var location = $(".v-moveToLocation:checked", editor).val();
                var choice = $(".v-moveToChoice", editor).attr("data-value");
                callback(location == "Below", parseInt(choice));
            }
            , 260, 500, false, null,
            { initFunction: initContentFunction, validateFunction: validateContentFunction });
    },
    deleteItems: function (items) {
        _.each(items, function (i) {
            var choice = _.find(choiceListTableEditor.choices, function (v) { return v.Id == i; });
            choice.Deleted = true;
        });

        choiceListTableEditor.refreshDataTable();

        if ($("tbody tr", choiceListTableEditor.datatable).length == 0) {
            choiceListTableEditor.datatable.a4datatable("setCurrentPage", "last");
        }
    },
    addChoice: function (code, text) {
        choiceListTableEditor.choices.push({ "Id": choiceListTableEditor.nextId++, "ChoiceListId": choiceListTableEditor.choiceListId, "Code": code, "Text": text, "Visible": true, "Default": false, "Exclusive": false, "Fixed": false, "ParentValue": "", "Position": ++choiceListTableEditor.lastPosition, "Deleted": false, "Edited": false, "Header": false });
        choiceListTableEditor.lastCode = code;
    },
    editChoice: function (id) {
        var currentQuestion = a4.top().questionnaireEditor.getInEditQuestion();
        var qId = a4.top().questionnaireEditor.blockController.getBlockItemIdFromElement(currentQuestion);
        var isPersisted = (id <= choiceListTableEditor.lastId);
        var choice = _.find(choiceListTableEditor.choices, function (c) { return c.Id == id; });
        var edited = ((choice && choice.Edited) || !isPersisted);
        var data = (edited) ? JSON.stringify(choice) : "";

        var loadEditContentFunction = function () {
            if (edited) {
                a4.callServerMethod(a4.top().questionnaireEditor.getUrl("ChoiceOptions"), { questionId: qId, choiceId: id, data: data },
                    function (result) {
                        $("iframe").contents().find('.v-optionsContent').html(result);
                        if (_.isFunction($("iframe")[0].contentWindow.setChoiceEvents)) {
                            $("iframe")[0].contentWindow.setChoiceEvents();
                        }
                    });
            }
        }

        modalDialog.showWindow(a4.top().questionnaireEditor.getUrl("ChoiceListTableChoiceOptions", { questionId: qId, choiceListId: choiceListTableEditor.choiceListId, choiceId: id, isPersisted: isPersisted, loadEntity: !edited }), 500, 750, { initFunction: loadEditContentFunction });
    },
    saveChoiceOptions: function (id, isDefault, exclusive, visible, fixed, oeType, oeTypeEnum, oeWidth, oeHeight, oeLines, oeSize, oeMaxLength, oeMinLength, oeDisplayWhen, oeEnforced, imageURL, color) {
        var choice = _.find(choiceListTableEditor.choices, function (c) { return c.Id == id; });

        if (choice) {
            choice.Edited = true;
            choice.OpenEndType = parseInt(oeType);
            choice.OpenEndTypeEnum = oeTypeEnum;
            choice.OpenEndWidth = oeWidth;
            choice.OpenEndHeight = oeHeight;
            choice.OpenEndLines = oeLines;
            choice.OpenEndSize = oeSize;
            choice.OpenEndMaxLength = oeMaxLength;
            choice.OpenEndMinLength = oeMinLength;
            choice.OpenEndDisplayWhenSelected = oeDisplayWhen;
            choice.EnforceOpenEnd = oeEnforced;

            var refresh = (choice.Default != isDefault || choice.Visible != visible || choice.Exclusive != exclusive || choice.Fixed != fixed);
            choice.Default = isDefault;
            choice.Visible = visible;
            choice.Exclusive = exclusive;
            choice.Fixed = fixed;
            choice.Settings = [];
            choice.Settings.push({ "Name": "Color", "Value": color });

            choice.TranslatableSettings = [];
            choice.TranslatableSettings.push({ "Name": "ImageUrl", "Value": imageURL });

            if (refresh) {
                choiceListTableEditor.refreshDataTable();
            }
        }
    },
    initializeDrilldownChoices: function (editQuestion) {
        if (choiceListTableEditor.isDrillDownList) {
            var firstListId = $(".v-drilldownEditorContainer .v-questionEditableItem:visible:first", editQuestion).attr("data-listId");
            choiceListTableEditor.isFirstDropdown = (choiceListTableEditor.choiceListId == firstListId);

            if (!choiceListTableEditor.isFirstDropdown) {
                var ancestor = $(".v-drilldownEditorContainer .v-questionEditableItem[data-listId='" + choiceListTableEditor.choiceListId + "']", editQuestion).prev();

                if (ancestor) {
                    if (ancestor.data("choices"))
                        choiceListTableEditor.drilldownParentOptions = ancestor.data("choices");
                    else {
                        var listId = ancestor.attr("data-listId");
                        var callback = function (result) {
                            choiceListTableEditor.drilldownParentOptions = _.filter(result, function (c) { return !c.Deleted; });
                        }
                        return a4.top().questionnaireEditor.loadLargeListChoices(listId, listId, false, callback);
                    }
                }
            }
        }
    },
    bindEvents: function () {
        $(document).on("click", ".h-importFile", function () {
            var choice = _.max(choiceListTableEditor.choices, function (c) { return isNaN(c.Code) ? 0 : parseInt(c.Code); });
            modalDialog.showWindow(a4.top().questionnaireEditor.getUrl("ImportChoices", { lastCode: choice.Code }), 350, 600);
        });

        $(document).on("click", ".v-confirmButton", function () {
            // Set added rows to 0, for server serialization
            _.each(_.filter(choiceListTableEditor.choices, function (a) { return a.Id > choiceListTableEditor.lastId; }), function (c) {
                c.Id = 0;
            });

            a4.top().questionnaireEditor.setChoiceListChoices($("#ChoiceListId").val(), choiceListTableEditor.choices);
            modalDialog.close();
        });

        $(document).on("keypress", ".v-code", function (e) { return DisableInvalidCharacters(e); });
    },
    getToolBarItems: function () {
        return [{ "Action": "addChoice", "Label": resources.AddChoice, "DisplayMode": dataTables.itemDisplayMode.always },
                { "Action": "deleteAll", "Label": resources.DeleteAll, "DisplayMode": dataTables.itemDisplayMode.always },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "moveUp", "Label": resources.MoveUp },
                { "Action": "moveDown", "Label": resources.MoveDown },
                { "Action": "moveTo", "Label": resources.MoveTo }];
    },
    getContextMenuItems: function () {
        return [{ "Action": "edit", "Label": resources.MoreSettings },
                { "Action": "editLogic", "Label": resources.EditLogic },
                { "Action": "moveUp", "Label": resources.MoveUp },
                { "Action": "moveDown", "Label": resources.MoveDown },
                { "Action": "moveTo", "Label": resources.MoveTo },
                { "Action": "delete", "Label": resources.Delete }];
    }
}

$(document).ready(function () {
    if ($(".v-choicesTable").length > 0) {
        var editChoices = a4.parent().questionnaireEditor.getChoiceListChoices($("#ChoiceListId").val());
        var editQuestion = a4.parent().questionnaireEditor.getInEditQuestion();
        choiceListTableEditor.choiceListId = parseInt($("#ChoiceListId").val());
        choiceListTableEditor.isDrillDownList = $(".v-drilldownEditorContainer", editQuestion).length > 0;

        var qType = parseInt($(".v-questionEdit", editQuestion).attr("data-qtype"));
        // Check ChoiceListChoiceDisplay for comprehensive rules
        choiceListTableEditor.showDefault = (qType <= 5 || qType >= 22);
        choiceListTableEditor.showFixed = (qType <= 4 || qType >= 11 && qType != 22);
        choiceListTableEditor.showExclusive = qType == 3 || qType == 10 || qType == 25;
        choiceListTableEditor.showHeader = qType == 1 || qType == 3 || qType == 33;

        if (editChoices)
            choiceListTableEditor.choices = jQuery.extend(true, [], editChoices);
        else {
            var choices = $("#JSONChoices");
            choiceListTableEditor.choices = (choices.length > 0 && choices.val() != "") ? $.parseJSON(choices.val()) : "";
        }

        if (_.size(choiceListTableEditor.choices) > 0) {
            choiceListTableEditor.lastId = parseInt(_.max(choiceListTableEditor.choices, function (c) { return parseInt(c.Id); }).Id);
            choiceListTableEditor.nextId = choiceListTableEditor.lastId + 1;
            choiceListTableEditor.lastPosition = Math.max(_.max(choiceListTableEditor.choices, function (c) { return parseInt(c.Position); }).Position, 1);
            var maxChoice = (_.size(choiceListTableEditor.choices) == 0) ? 0 : _.max(choiceListTableEditor.choices, function (c) { return isNaN(c.Code) ? 0 : parseInt(c.Code); });
            choiceListTableEditor.lastCode = (maxChoice) ? parseInt(maxChoice.Code) + 1 : 1;
            // Set id for added rows that haven't been serialized
            _.each(_.filter(choiceListTableEditor.choices, function (a) { return a.Id == 0; }), function (c) {
                c.Id = choiceListTableEditor.nextId++;
            });
        }

        $.when($, choiceListTableEditor.initializeDrilldownChoices(editQuestion)).then(
            function () {
                choiceListTableEditor.initializeDataTable();
                choiceListTableEditor.bindEvents();
            }
        );
    }
});

function setImportedChoices(data, overwrite) {
    var newChoices = $.parseJSON(data);

    if (overwrite) {
        choiceListTableEditor.choices = _.reject(choiceListTableEditor.choices, function (c) { return c.Id > choiceListTableEditor.lastId });
        _.each(choiceListTableEditor.choices, function (c) { return c.Deleted = true });
    }

    $.each(newChoices, function (index, item) {
        choiceListTableEditor.addChoice(item.Value, item.Label);
    });

    choiceListTableEditor.refreshDataTable();
}

function updateChoiceSkipLogic(choiceId, skipLogic, displayLogic) {
    var choice = _.find(choiceListTableEditor.choices, function (c) { return c.Id == choiceId; });

    if (choice) {
        choice.SkipLogic = JSON.stringify(skipLogic);
        choice.DisplayLogic = JSON.stringify(displayLogic);
    }
}